﻿<?php
session_start();
include 'conexao.php'; 

$mensagem = '';

// --- TRATAMENTO DO FORMULÁRIO DE EDIÇÃO (POST) ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['salvar_edicao'])) {
    
    // Coleta dos dados
    $aluno_id = $_POST['aluno_id'] ?? null;
    $nome_completo = trim($_POST['nome_completo'] ?? '');
    $idade = $_POST['idade'] ?? null;
    $genero = $_POST['genero'] ?? null;
    $data_nascimento = $_POST['data_nascimento'] ?? null;
    $contacto = $_POST['contacto'] ?? null;
    $endereco = $_POST['endereco'] ?? null;
    $opcao_lingua = $_POST['opcao_lingua'] ?? 'Português';
    $vez = $_POST['vez'] ?? 1;
    $observacoes = $_POST['observacoes'] ?? null;
    $foto_nome_atual = $_POST['foto_existente'] ?? null;
    $turma_id = $_POST['turma_id'] ?? null; 
    
    // NOVO CAMPO: Número de Processo
    $numero_processo = $_POST['numero_processo'] ?? null;

    // Outros campos adicionais
    $naturalidade = $_POST['naturalidade'] ?? null;
    $provincia = $_POST['provincia'] ?? null;
    $bi_numero = $_POST['bi_numero'] ?? null;
    $bi_emitido_em = $_POST['bi_emitido_em'] ?? null;
    $bi_data_emissao = $_POST['bi_data_emissao'] ?? null;
    $municipio = $_POST['municipio'] ?? null;
    $nome_pai = $_POST['nome_pai'] ?? null;
    $nome_mae = $_POST['nome_mae'] ?? null;


    if ($aluno_id) {
        // Lógica de upload de foto
        if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
            $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
            $foto_nome_atual = uniqid('foto_') . '.' . $ext;
            // Certifique-se de que a pasta 'fotos_alunos' existe e tem permissão de escrita
            move_uploaded_file($_FILES['foto']['tmp_name'], "fotos_alunos/$foto_nome_atual");
        }
        
        // Prepara a query de atualização
        $stmt = $conn->prepare("UPDATE alunos SET 
            nome = ?, idade = ?, genero = ?, data_nascimento = ?, contacto = ?, 
            endereco = ?, foto = ?, opcao_lingua = ?, vez = ?, observacoes = ?, 
            naturalidade = ?, provincia = ?, bi_numero = ?, bi_emitido_em = ?, 
            bi_data_emissao = ?, municipio = ?, nome_pai = ?, nome_mae = ?,
            numero_processo = ? 
            WHERE id = ?");
        
        if ($stmt === false) {
            $mensagem = "❌ Erro na preparação da query: " . $conn->error;
        } else {
            // "s" no bind_param adicionado para $numero_processo (total de 19 parâmetros 's' ou 'i')
            $stmt->bind_param("sisssssisssssssssssi", 
                $nome_completo, $idade, $genero, $data_nascimento, $contacto, $endereco, 
                $foto_nome_atual, $opcao_lingua, $vez, $observacoes, 
                $naturalidade, $provincia, $bi_numero, $bi_emitido_em, 
                $bi_data_emissao, $municipio, $nome_pai, $nome_mae, 
                $numero_processo, $aluno_id);
            
            if ($stmt->execute()) {
                $mensagem = "✅ Dados do aluno atualizados com sucesso!";
            } else {
                $mensagem = "❌ Erro ao atualizar dados do aluno: " . $stmt->error;
            }
            $stmt->close();
        }
    } else {
        $mensagem = "⚠️ Erro: Nenhum aluno selecionado para edição.";
    }
}

// Busca todos os alunos para o SELECT (APENAS ID E NOME)
$alunos = $conn->query("SELECT id, nome FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Editar Aluno</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f0f2f5; }
        .topbar { background-color: #007bff; color: white; padding: 15px 20px; font-size: 20px; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; }
        .sidebar { position: fixed; top: 60px; left: 0; width: 220px; height: 100%; background-color: #111827; padding-top: 20px; }
        .sidebar a { display: block; color: white; padding: 12px 20px; text-decoration: none; font-weight: 500; }
        .sidebar a:hover { background-color: #1e3a8a; }
        .main { margin-left: 220px; padding: 80px 30px 30px 30px; }
        .container { max-width: 900px; background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #007bff; margin-bottom: 25px; }
        form { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .full { grid-column: 1 / 3; }
        label { display: block; font-weight: 600; margin-bottom: 5px; }
        input, select, textarea { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-size: 14px; }
        input[type="file"] { padding: 6px; }
        button { background-color: #007bff; border: none; color: white; padding: 12px 20px; font-size: 16px; border-radius: 8px; cursor: pointer; transition: 0.3s; }
        button:hover { background-color: #0056b3; }
        .mensagem { margin-top: 20px; text-align: center; font-size: 16px; }
        .button-group { display: flex; justify-content: center; gap: 10px; }
        .info-box { background-color: #f9f9f9; padding: 10px; border: 1px dashed #ccc; border-radius: 8px; margin-top: 5px; }

        @media (max-width: 768px) {
            .sidebar { width: 100%; height: auto; position: relative; }
            .main { margin-left: 0; padding-top: 120px; }
            form { grid-template-columns: 1fr; }
            .full { grid-column: 1 / 2; }
            .button-group { flex-direction: column; }
        }
    </style>
</head>
<body>

<div class="topbar">
    📚 SISMAG- Sistema de Gestão Escolar
</div>

<div class="sidebar">
    <a href="painel_secretaria_geral.php">🏠 Início</a>
    <a href="matricular_aluno.php">📋 Matricular Novo</a>
    <a href="editar_aluno.php">✏️ Editar Alunos</a>
    <a href="cadastrar_turma2.php">🏫 Turmas</a>
    <a href="login.php">🔓 Sair</a>
</div>

<div class="main">
    <div class="container">
        <h2>✏️ Editar Dados do Aluno</h2>
        <div class="full" style="text-align: center;">
            <?php if (!empty($mensagem)): ?>
                <div class="mensagem">
                    <?= $mensagem ?>
                </div>
            <?php endif; ?>
        </div>

        <form method="POST" action="" enctype="multipart/form-data" id="formEdicao">
            <input type="hidden" name="aluno_id" id="aluno_id" value="">
            <input type="hidden" name="foto_existente" id="foto_existente" value="">
            <input type="hidden" name="turma_id" id="turma_id_edicao" value="">

            <div class="full" style="margin-bottom: 20px;">
                <label>Selecionar Aluno para Edição:</label>
                <select id="aluno_select_completa" class="aluno_select">
                    <option value="">-- Selecione um aluno para carregar os dados --</option>
                    <?php foreach ($alunos as $a): ?>
                        <option value="<?= $a['id'] ?>">
                            <?= htmlspecialchars($a['nome']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="full">
                <label>Nome Completo:</label>
                <input type="text" name="nome_completo" id="nome_completo" value="" required disabled>
            </div>
            
            <div class="full">
                <label>Número de Processo:</label>
                <input type="text" name="numero_processo" id="numero_processo" value="" disabled>
            </div>
            <div>
                <label>Idade:</label>
                <select name="idade" id="idade" required disabled>
                    <option value="">-- Selecione --</option>
                    <?php for ($i = 12; $i <= 60; $i++): ?>
                        <option value="<?= $i ?>"><?= $i ?> anos</option>
                    <?php endfor; ?>
                </select>
            </div>

            <div>
                <label>Género:</label>
                <select name="genero" id="genero" required disabled>
                    <option value="">-- Selecione --</option>
                    <option value="Masculino">Masculino</option>
                    <option value="Feminino">Feminino</option>
                    <option value="Outro">Outro</option>
                </select>
            </div>

            <div>
                <label>Data de Nascimento:</label>
                <input type="date" name="data_nascimento" id="data_nascimento" value="" disabled>
            </div>
            
            <div class="full">
                <label>Nº do Bilhete de Identidade (BI):</label>
                <input type="text" name="bi_numero" id="bi_numero" value="" disabled>
            </div>
            <div>
                <label>Local de Emissão do BI:</label>
                <input type="text" name="bi_emitido_em" id="bi_emitido_em" value="" disabled>
            </div>
            <div>
                <label>Data de Emissão do BI:</label>
                <input type="date" name="bi_data_emissao" id="bi_data_emissao" value="" disabled>
            </div>

            <div>
                <label>Naturalidade:</label>
                <input type="text" name="naturalidade" id="naturalidade" value="" disabled>
            </div>

            <div>
                <label>Província:</label>
                <input type="text" name="provincia" id="provincia" value="" disabled>
            </div>

            <div>
                <label>Município:</label>
                <input type="text" name="municipio" id="municipio" value="" disabled>
            </div>

            <div class="full">
                <label>Nome do Pai:</label>
                <input type="text" name="nome_pai" id="nome_pai" value="" disabled>
            </div>

            <div class="full">
                <label>Nome da Mãe:</label>
                <input type="text" name="nome_mae" id="nome_mae" value="" disabled>
            </div>

            <div>
                <label>Contacto:</label>
                <input type="text" name="contacto" id="contacto" value="" disabled>
            </div>

            <div>
                <label>Endereço:</label>
                <input type="text" name="endereco" id="endereco" value="" disabled>
            </div>
            
            <div class="full" id="turma_selecao_container">
                <label>Turma Atual (Classe, Nome, Turno, Ano):</label>
                <div class="info-box" id="turma_display">Selecione um aluno acima.</div>
            </div>
            
            <div class="full">
                <label>Foto do Aluno (Substituir):</label>
                <input type="file" name="foto" disabled id="foto_input">
                
                <div style="margin-top: 10px; text-align: center;">
                    <img id="foto_atual_display" src="" alt="Foto do Aluno Atual" 
                         style="max-width: 150px; max-height: 200px; border: 1px solid #ccc; display: none;">
                    <p id="foto_status">Nenhuma foto carregada.</p>
                </div>
            </div>

            <div>
                <label>Opção de Língua:</label>
                <select name="opcao_lingua" id="opcao_lingua" required disabled>
                    <option value="Inglês/Francês">Inglês/Francês</option>
                 
                </select>
            </div>

            <div>
                <label>Vez da Matrícula:</label>
                <select name="vez" id="vez" required disabled>
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <option value="<?= $i ?>"><?= $i ?>ª Vez</option>
                    <?php endfor; ?>
                </select>
            </div>
            
            <div class="full">
                <label>Observações:</label>
                <textarea name="observacoes" id="observacoes" rows="4" disabled></textarea>
            </div>

            <div class="full" style="text-align:center;">
                <div class="button-group">
                    <button type="submit" name="salvar_edicao" id="btn_salvar_edicao" disabled>✅ Salvar Alterações</button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
$(function() {
    
    // Lista de TODOS os campos que serão habilitados/desabilitados
    const camposFormulario = [
        '#nome_completo', '#numero_processo', '#idade', '#genero', '#data_nascimento', 
        '#contacto', '#endereco', '#opcao_lingua', '#vez', '#observacoes', 
        '#foto_input', '#btn_salvar_edicao',
        '#bi_numero', '#bi_emitido_em', '#bi_data_emissao', 
        '#naturalidade', '#provincia', '#municipio', 
        '#nome_pai', '#nome_mae'
    ];

    // 1. Função para habilitar/desabilitar o formulário
    function toggleFormulario(habilitar) {
        camposFormulario.forEach(selector => {
            $(selector).prop('disabled', !habilitar);
        });
    }

    // 2. Função para preencher os campos do formulário
    function preencherDadosAluno(dados) {
        // Campos de Texto/Hidden/Select
        $("#aluno_id").val(dados.id);
        $("#foto_existente").val(dados.foto); 
        $("#nome_completo").val(dados.nome);
        $("#numero_processo").val(dados.numero_processo); // Preenchendo o Número de Processo
        $("#data_nascimento").val(dados.data_nascimento);
        $("#contacto").val(dados.contacto);
        $("#endereco").val(dados.endereco);
        
        // Novas Colunas
        $("#bi_numero").val(dados.bi_numero);
        $("#bi_emitido_em").val(dados.bi_emitido_em);
        $("#bi_data_emissao").val(dados.bi_data_emissao);
        $("#naturalidade").val(dados.naturalidade);
        $("#provincia").val(dados.provincia);
        $("#municipio").val(dados.municipio);
        $("#nome_pai").val(dados.nome_pai);
        $("#nome_mae").val(dados.nome_mae);
        
        // Observações 
        $("#observacoes").val(dados.observacoes || ''); 
        
        // Selects
        $("#idade").val(dados.idade);
        $("#genero").val(dados.genero);
        $("#opcao_lingua").val(dados.opcao_lingua);
        $("#vez").val(dados.vez);
        
        // Informação da Turma (Exibição)
        const turmaTexto = 
            `${dados.classe ? dados.classe + 'ª Classe' : 'N/A'} - ` + 
            `${dados.nome_turma_display || 'N/A'} - ` +
            `${dados.curso || 'N/A'} (${dados.turno || 'N/A'})`;
            
        $('#turma_display').text(turmaTexto);
        $('#turma_id_edicao').val(dados.turma_id); 
        
        // --- LÓGICA PARA EXIBIR A FOTO ATUAL ---
        const fotoNome = dados.foto;
        const fotoDisplay = $('#foto_atual_display');
        const fotoStatus = $('#foto_status');

        if (fotoNome) {
            // Caminho completo: verifica a pasta 'fotos_alunos'
            const caminhoCompleto = "fotos_alunos/" + fotoNome; 
            
            fotoDisplay.attr('src', caminhoCompleto).show();
            fotoStatus.text("Foto atual carregada.");
        } else {
            fotoDisplay.attr('src', '').hide();
            fotoStatus.text("Aluno não possui foto cadastrada.");
        }
        // ---------------------------------------
        
        // HABILITA A EDIÇÃO
        toggleFormulario(true);
    }

    // NOVA FUNÇÃO para centralizar o reset e a limpeza de forma silenciosa
    function limparEBloquear(mensagemTurma) {
        $("#aluno_select_completa").val(""); 
        $("#aluno_id").val("");
        $("#formEdicao")[0].reset(); 
        $('#turma_display').text(mensagemTurma);
        
        // Esconde e reseta a foto
        $('#foto_atual_display').attr('src', '').hide();
        $('#foto_status').text("Nenhuma foto carregada.");
        
        toggleFormulario(false);
    }
    
    // 3. Listener para o campo SELECT
    $("#aluno_select_completa").on("change", function() {
        const alunoId = $(this).val();
        
        if (alunoId === "") {
            limparEBloquear("Selecione um aluno acima.");
            
        } else {
            $('#turma_display').text("Carregando..."); // Feedback visual

            $.ajax({
                url: "buscar_aluno_dados.php", // Certifique-se que este arquivo existe e retorna os dados
                type: "GET",
                dataType: "json",
                data: { aluno_id: alunoId }, 
                success: function(response) {
                    if (response.length > 0) {
                        const dadosAluno = response[0];
                        preencherDadosAluno(dadosAluno);
                    } else {
                        limparEBloquear("Dados não encontrados. Selecione novamente.");
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Erro na comunicação AJAX:", status, error); 
                    limparEBloquear("Erro de comunicação com o servidor.");
                }
            });
        }
    });

    // Inicializa o formulário desabilitado ao carregar a página
    toggleFormulario(false); 
});
</script>

</body>
</html>